/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.gdarp;

import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dark_roleplay.gdarp.Constants;
import net.dark_roleplay.gdarp.config.PackConfig;
import net.dark_roleplay.gdarp.pack_finders.MultiFilePackFinder;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.RepositorySource;

public class CommonClass {
    private static Path GAME_DIR = Path.of(".", new String[0]);

    public static Path getGameDir() {
        return GAME_DIR;
    }

    public static RepositorySource getRepositorySource(PackType type, boolean force) {
        HashSet<File> files = new HashSet<File>();
        Optional<List<String>> packFolders = switch (type) {
            case PackType.CLIENT_RESOURCES -> PackConfig.getRequiredResourceacks();
            case PackType.SERVER_DATA -> {
                if (force) {
                    yield PackConfig.getRequiredDatapacks();
                }
                yield PackConfig.getOptionalDatapacks();
            }
            default -> Optional.empty();
        };
        packFolders.ifPresent(list -> list.stream().map(str -> new File(GAME_DIR.toFile(), "/" + str)).forEach(files::add));
        return new MultiFilePackFinder(force, type, nameComp -> nameComp, files);
    }

    static {
        String launchArgument = System.getProperty("sun.java.command");
        System.out.println(launchArgument);
        if (launchArgument == null) {
            Constants.LOG.warn("Unable to find launch arguments, the mod might not function as expected.");
        } else if (launchArgument.contains("gameDir")) {
            Pattern pattern = Pattern.compile("gameDir\\s(.+?)(?:\\s--|$)");
            Matcher matcher = pattern.matcher(launchArgument);
            if (!matcher.find()) {
                Constants.LOG.error("Unable to find gameDir in launch arguments '{}' even though it was specified", (Object)launchArgument);
            } else {
                String gameDirParam = matcher.group(1);
                GAME_DIR = Path.of(gameDirParam, new String[0]);
            }
        }
    }
}

